/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.util.logging.Level;
import java.util.logging.Logger;
import panther.util.general.ErrorUtils;

public class PrintUtils {
    public static final Logger LOGGER_DEFAULT = Logger.getLogger("Default");
    public static final Logger LOGGER_MEMORY = Logger.getLogger("MemoryUsage");
    public static final Logger LOGGER_THREAD = Logger.getLogger("Threads");

    public static void println(Object object) {
        PrintUtils.println(object == null ? "null" : object.toString());
    }

    public static void println(String string) {
        LOGGER_DEFAULT.log(Level.FINE, string);
    }

    public static void warning(String string) {
        LOGGER_DEFAULT.warning(string);
    }

    public static void endConstructor(Object object) {
        PrintUtils.log(LOGGER_MEMORY, Level.FINE, "CONSTRUCT", object, null);
    }

    public static void beginCleanUp(Object object, String string) {
        PrintUtils.beginCleanUp(object, string, null);
    }

    public static void endCleanUp(Object object, String string) {
        PrintUtils.endCleanUp(object, string, null);
    }

    public static void beginCleanUp(Object object, String string, String string2) {
        PrintUtils.log(LOGGER_MEMORY, Level.FINER, "START " + string.toUpperCase(), object, string2);
    }

    public static void endCleanUp(Object object, String string, String string2) {
        PrintUtils.log(LOGGER_MEMORY, Level.FINER, "END " + string.toUpperCase(), object, string2);
    }

    public static void startFinalize(Object object) {
        PrintUtils.startFinalize(object, null);
    }

    public static void endFinalize(Object object) {
        PrintUtils.endFinalize(object, null);
    }

    public static void startFinalize(Object object, String string) {
        PrintUtils.log(LOGGER_MEMORY, Level.FINE, "START FINALIZE", object, string);
    }

    public static void endFinalize(Object object, String string) {
        PrintUtils.log(LOGGER_MEMORY, Level.FINE, "END FINALIZE", object, string);
    }

    public static void startThread(Thread thread) {
        PrintUtils.startThread(thread, null);
    }

    public static void endThread(Thread thread) {
        PrintUtils.endThread(thread, null);
    }

    public static void startThread(Thread thread, String string) {
        PrintUtils.log(LOGGER_THREAD, Level.FINE, "START THREAD", thread, string);
    }

    public static void endThread(Thread thread, String string) {
        PrintUtils.log(LOGGER_THREAD, Level.FINE, "END THREAD", thread, string);
    }

    protected static void log(Logger logger, Level level, String string, Object object, String string2) {
        try {
            String string3 = object == null ? "" : object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
            String string4 = string2 == null ? "" : " in " + string2;
            String string5 = string + " " + string3 + string4;
            logger.log(level, string5);
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
        }
    }
}

